package com.padroesdr.decorator.exemplos.mma;

public class Principal {

    public static void main(String args[]) {

        System.out.println("Fighter 1:");

        Fighter fighter1 = new JapaneseFighter();

        fighter1 = new Karate(fighter1);

        fighter1.toAttack();

        fighter1.defend();

        // Changing the martial art in runtime
        System.out.println("Changing the Japanese martial art in runtime...");

        /* The following lines aim to "undecorate" the last martial art, due to the only one martial art at time request
         * from this problem.
         * This approach is only for making this example simpler, for learning purposes. A desirable approach would be
         * creating all the instances through the Factory pattern, and controlling the decorations and undecorations
         * inside a manager class.
         */
        if (fighter1 instanceof MartialArtDecorator) {
            fighter1 = ((MartialArtDecorator) fighter1).getComponent();
        }

        fighter1 = new Judo(fighter1);

        fighter1.toAttack();

        fighter1.defend();

        System.out.println("Fighter 2:");
        Fighter fighter2 = new BrazillianFighter();

        fighter2 = new JiuJitsu(fighter2);

        fighter2.toAttack();

        fighter2.defend();
    }

}
